# include <iostream>
using namespace std;

class item{
	private:
		item* next;
		int value;
	public:
		item(int x){next = 0; value = x;};
	friend class queue;
};

class queue{
	private:
		item* front;
		item* back;
		int count;
	public:
		queue(){front = 0; back = 0; count = 0;};
		void enqueue(int);
		item* dequeue();
		bool is_empty();
		int size();
		void print();		
};

void queue::enqueue(int x){
	
	item* elem = new item(x);
	if(count++ == 0){
		front = elem;
		back = elem;
		return;
	}
	
	back->next = elem;
	back = elem;
	return;
}

item* queue::dequeue(){
	item* elem = front;
	front = front->next;
	return elem;
}

bool queue::is_empty(){
	return (count == 0);
}

int queue::size(){
	return count;
}

void queue::print(){
	item* elem = front;
	while(elem){
		cout << elem->value << "; ";
		elem = elem->next;
	}
	cout << endl;
	return;
}


int main(){
	
	queue q;
	
	cout << "q.size(): " << q.size() << "; q.is_empty(): " << q.is_empty() << endl;
	
	for(int i = 1; i <= 20; i++){
		q.enqueue((i%7 + 1) * i);
	}
	
	q.print();	
	cout << "q.size(): " << q.size() << "; q.is_empty(): " << q.is_empty() << endl;
	
	for(int i = 0; i < 10; i++){
		delete q.dequeue();
	}
	
	q.print();
	cout << "q.size(): " << q.size() << "; q.is_empty(): " << q.is_empty() << endl;
	
	return 0;
}