# include <iostream>
using namespace std;

template <typename T>
class stack_elem{
	private:
		T value;
		stack_elem<T>* next;
	public:
		stack_elem(T);
		template <typename>
		friend class stack;
};

template <typename T>
stack_elem<T>::stack_elem(T v){
	value = v;
	next = 0;
}

template <typename T>
class stack{
	private:
		int size;
		stack_elem<T>* top;
	public:
		stack();
		bool is_empty();
		stack_elem<T>* pop();
		stack_elem<T>* get_top();
		void push(stack_elem<T>*);
		void print();
};

template <typename T>
stack<T>::stack(){
	size = 0;
	top = 0;
}
template <typename T>
bool stack<T>::is_empty(){
	return (size == 0);
}
template <typename T>
stack_elem<T>* stack<T>::pop(){
	stack_elem<T>* to_return = top;
	top = top->next;
	size--;
	return to_return;
}

template <typename T>
stack_elem<T>* stack<T>::get_top(){
	return top;
}

template <typename T>
void stack<T>::push(stack_elem<T>* new_elem){
	new_elem->next = top;
	top = new_elem;
	size++;
}

template <typename T>
void stack<T>::print(){
	stack_elem<T>* elem = top;
	while(elem){
		cout << elem->value << "; ";
		elem = elem->next;
	}
	cout << endl;
}


int main(){
	
	stack<string> s1;
	
	cout << s1.is_empty() << endl;
	
	stack_elem<string> e1("a");
	stack_elem<string> e2("b");
	stack_elem<string> e3("c");
	
	s1.push(&e1);
	s1.push(&e2);
	s1.push(&e3);
	
	cout << s1.is_empty() << endl;
	
	s1.print();
	
	s1.pop();
	s1.pop();
	s1.pop();
	
	cout << s1.is_empty() << endl;
	
	return 0;
}