#include "katze.h"
using namespace std;

// Konstruktor (Standard-Name: Kitty)
Katze::Katze(string n = "Kitty"){
	name = n;
	energie = 10;
}

// Lässt die Katze schlafen
// Wenn sie nicht müde ist (energie == 60), dann schläft sie nicht
// sonst erhöht es energie um dauer (höchstens 60)
void Katze::schlafen(int dauer){
	if(energie == 60){
		cout << name + " ist nicht müde genug zum schlafen." << endl;
		return;
	}
	
	energie += dauer;
	
	if(energie > 60){
		energie = 60;
	}
	
	return;
}

// Lässt die Katze spielen
// Wenn sie zu müde ist (energie == 0), dann spielt sie nicht
// sonst veringert es energie um dauer (mindestens 0)
void Katze::spielen(int dauer){
	if(energie == 0){
		cout << name + " ist zu müde zum spielen." << endl;
		return;
	}
	
	energie -= dauer;
	
	if(energie < 0){
		energie = 0;
	}
	
	return;
}
// Gibt einen string zurück, der energie beschreibt
string Katze::status(){
	if(energie == 60){
		return name + " ist voller Energie!";
	}
	if(energie > 40){
		return name + " würde gerne spielen.";
	}
	if(energie > 20){
		return name + " ist zufrieden.";
	}
	if(energie > 0){
		return name + " ist müde und möchte schlafen.";
	}
	return name + " ist völlig ausgelaugt.";
}