# include <iostream>
using namespace std;

template <typename E>
class Point{
public:
   Point(E new_x, E new_y);
   void move(E dx, E dy);
   void print();
   
private:
   E x;
   E y;
};

template <typename E>
Point<E>::Point(E new_x, E new_y){ x = new_x; y = new_y; }

template <typename E>
void Point<E>::move(E dx, E dy){
	x = x + dx;
	y = y + dy;
}
template <typename E>
void Point<E>::print(){
	cout << "(" << x << ", " << y << ")";
}

int main(){
	Point<double> a(1.2, 0.7);
	a.move(0.4, 1.2);
	a.print(); // a = (1.6, 1.9)
	
	Point<string> b("ab", "cd");
	b.move("xy", "xz");
	b.print(); // b = (abxy, cdxz)
	
	Point<bool> c(false, false);
	c.move(true, false);
	c.print(); // c = (true, false)
}