// SortBean.java

import java.util.Vector;

public class SortBean implements javax.ejb.SessionBean {

  final static private boolean _debug = System.getProperty("SortBeanDebug") != null;

  private javax.ejb.SessionContext _context;

  public void setSessionContext(javax.ejb.SessionContext sessionContext) {
    _context = sessionContext;
    if(_debug) {
      System.out.println("\tsetSessionContext: " + this);
    }
  }

  public void ejbCreate() throws java.rmi.RemoteException {
    if(_debug) {
      System.out.println("\tejbCreate: " + this);
    }
  }

  public void ejbRemove() {
    if(_debug) {
      System.out.println("\tejbRemove: " + this);
    }
  }

  public Vector sort(Vector v, Compare c) throws java.rmi.RemoteException {
    if(_debug) {
      System.out.println("\tsort(" + v + "): " + this);
    }
    if(v == null) {
      return null;
    }
    int size = v.size();
    if(size < 2) {
      return v;
    }
    else {
      int half = size / 2;
      Vector a = new Vector(half);
      Vector b = new Vector(size - half);
      for(int i = 0; i < half; i++) {
        a.addElement(v.elementAt(i));
      }
      for(int i = half; i < size; i++) {
        b.addElement(v.elementAt(i));
      }
      try {
        Sort helperA = ((SortHome) _context.getEJBHome()).create();
        Sort helperB = ((SortHome) _context.getEJBHome()).create();
        Sort self = (Sort) _context.getEJBObject();
        Vector result = self.merge(helperA.sort(a, c), helperB.sort(b, c), c);
        helperA.remove();
        helperB.remove();
        return result;
      }
      catch(javax.ejb.CreateException e) {
        throw new java.rmi.ServerException("Could not create sort instance", e);
      }
      catch(javax.ejb.RemoveException e) {
        throw new java.rmi.ServerException("Could not remove sort instance", e);
      }
    }
  }

  public Vector merge(Vector a, Vector b, Compare c) {
    if(_debug) {
      System.out.println("\tmerge(" + a + ", " + b + "): " + this);
    }
    if(a == null) {
      return b;
    }
    if(b == null) {
      return null;
    }
    int size = a.size() + b.size();
    Vector v = new Vector(size);
    int aIndex = 0, bIndex = 0;
    for(int i = 0; i < size; i++) {
      if(aIndex == a.size()) {
        v.addElement(b.elementAt(bIndex++));
      }
      else if(bIndex == b.size()) {
        v.addElement(a.elementAt(aIndex++));
      }
      else if(c.compare(a.elementAt(aIndex), b.elementAt(bIndex)) <= 0) {
        v.addElement(a.elementAt(aIndex++));
      }
      else {
        v.addElement(b.elementAt(bIndex++));
      }
    }
    return v;
  }

  public void ejbActivate() {
    if(_debug) {
      System.out.println("\tejbActivate: " + this);
    }
  }

  public void ejbPassivate() {
    if(_debug) {
      System.out.println("\tejbPassivate: " + this);
    }
  }

  public String toString() {
    return "SortBean[context=" + _context + "]";
  }

}
