// SortClient.java

import java.util.*;

class NumberCompare implements Compare, java.io.Serializable {
  public int compare(Object lhs, Object rhs) {
    return ((Number) lhs).intValue() - ((Number) rhs).intValue();
  }
}

class StringCompare implements Compare, java.io.Serializable {
  public int compare(Object lhs, Object rhs) {
    return ((String) lhs).compareTo((String) rhs);
  }
}
      
public class SortClient {
  
  private static void assert(boolean assertion) {
    if(!assertion) {
      new Error("Failed assertion!").printStackTrace();
      System.exit(1);
    }
  }

  private static void verify(Vector in, Vector out, Compare compare) {
    System.out.println("in:  " + in);
    System.out.println("out: " + out);
    assert(in.size() == out.size());
    { // verify that all the elements are still there...
      Vector inCopy = (Vector) in.clone();
      for(int i = 0; i < out.size(); i++) {
        assert(inCopy.removeElement(out.elementAt(i)));
      }
    }
    // verify that all the elements are still in order...
    if(out.size() > 0) {
      Object previousElement = out.elementAt(0);
      for(int i = 1; i < out.size(); i++) {
        assert(compare.compare(previousElement, out.elementAt(i)) <= 0);
        previousElement = out.elementAt(i);
      }
    }
  }

  public static void main(String[] args) throws Exception {

    // get a JNDI context using the Naming service
    javax.naming.Context context = new javax.naming.InitialContext();

    Object ref = context.lookup("sort");
    SortHome home = 
      (SortHome) javax.rmi.PortableRemoteObject.narrow(ref, SortHome.class);

    Sort sort = home.create();
    {
      Compare compare = new NumberCompare();
      Vector in = new Vector();
      in.addElement(new Integer(1));
      verify(in, sort.sort(in, compare), compare);
      in.addElement(new Integer(2));
      verify(in, sort.sort(in, compare), compare);
      in.addElement(new Integer(7));
      in.addElement(new Integer(3));
      in.addElement(new Integer(8));
      in.addElement(new Integer(10));
      in.addElement(new Integer(4));
      in.addElement(new Integer(9));
      in.addElement(new Integer(5));
      in.addElement(new Integer(6));
      verify(in, sort.sort(in, compare), compare);
    } 
    {
      Compare compare = new NumberCompare();
      Random random = new Random();
      Vector in = new Vector();
      for(int i = 0; i < 25; i++) {
        in.addElement(new Integer(random.nextInt() % 100));
      }
      verify(in, sort.sort(in, compare), compare);
    }
    {
      Compare compare = new NumberCompare();
      Random random = new Random();
      Vector in = new Vector();
      in.addElement(new    Byte((byte)   (random.nextInt() % 10)));
      in.addElement(new  Double((double) (random.nextInt() % 10)));
      in.addElement(new   Float((float)  (random.nextInt() % 10)));
      in.addElement(new Integer((int)    (random.nextInt() % 10)));
      in.addElement(new    Long((long)   (random.nextInt() % 10)));
      in.addElement(new   Short((short)  (random.nextInt() % 10)));
      verify(in, sort.sort(in, compare), compare);
    }
    {
      Compare compare = new StringCompare();
      Vector in = new Vector();
      in.addElement("this");
      in.addElement("is");
      in.addElement("a");
      in.addElement("test");
      verify(in, sort.sort(in, compare), compare);
    }
    sort.remove();
  }

}

